/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/*
  make a map file from d cards to e
*/

#include <stdarg.h>

#include "lx.h"
#include "lx_map_file.h"
#include "lx_spine_route.h"
#include "lx_route_file.h"

lx_t lx;

static void usage (char*s)
{
  printf ("usage: %s <map file>\n", s);
  exit (1);
}

int main (int argc, char*argv [])
{
  lx_map_t*m;
  lx_node_t*n1, *n2, *x;
  FILE*fp;
  int i, p;

  mi_verbose_flag = 0;

  if (argc != 2)
    usage (argv [0]);
  
  if (!(fp = fopen (argv [1], "r")))
  {
    printf ("couldn't open %s", argv [1]);
    usage (argv [0]);
  }
  
  lx_init (&lx);
  
  if (!lx_map_file_read (fp, &lx.maps [0]))
  {
    printf ("lx_map_file_read () failed\n");
    exit (1);
  }
  m = lx.maps;

  fclose (fp);  
  
  for (i = 0; i < m->num_hosts - 1; i+=2)
  {
    n1 = mi_index2node (m->host_array [i]);
    insist (n1 && !n1->xbar);

    n2 = mi_index2node (m->host_array [i + 1]);
    insist (n2 && !n2->xbar);

    insist (!lx_get_node (n1, 1) && !lx_get_node (n2, 1));

    x = lx_get_node (n2, 0);
    insist (x && x->xbar);
    p = lx_get_port (n2, 0);
    lx_delete_node (m, lx_remove_from_anywhere (n2));
    lx_connect (n1, 1, x, p);
  }

  n1 = (lx_node_t*) lx_peek (&m->hosts);
  for (i = 0; n1; i++, n1 = mi_index2node (n1->next))
  {
    m->host_array [i] = mi_node2index (n1);
    n1->index = i;
  }

  insist (i == m->num_hosts);
  
  lx_map_file_write (stdout, m);  

  except:  
  return 0;
}

